//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
// Amyuni PDF Converter - PDF Compatible Printer Driver                         //
//                                                                              //
// Copyright AMYUNI Consultants - AMYUNI Technologies                           //
// 1998-2005, All Rights Reserved                   ***** CONFIDENTIAL *****    //
//                                                                              //
// Permission to use this work for any purpose must be expressly obtained       //
// from: AMYUNI Technologies, http://www.amyuni.com, management@amyuni.com      //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////
//
#ifdef __cplusplus
extern "C"   {
#endif

// the following events can be sent by the  driver
// these are predefined by Windows DDK
#ifndef DOCUMENTEVENT_LAST
#define DOCUMENTEVENT_LAST	14
#endif // #ifndef DOCUMENTEVENT_LAST
#define DOCUMENTEVENT_STARTDOCPRE   5   // before StartDoc is handled
#define DOCUMENTEVENT_STARTDOCPOST 13   // after StartDoc is handled
#define DOCUMENTEVENT_STARTPAGE     6   // StartPage handled
#define DOCUMENTEVENT_ENDPAGE       7   // EndPage handled
#define DOCUMENTEVENT_ENDDOCPRE     8   // before EndDoc is handled
#define DOCUMENTEVENT_ENDDOCPOST   12   // after EndDoc is handled
#define DOCUMENTEVENT_ENABLEDPRE   15 // this is problematic because the value changes with different SDKs (DOCUMENTEVENT_LAST + 1)   // before checking if printer is enabled

// private escapes
#define	ESCAPE_SETALPHA			247		// Set Stroke/Fill alpha levels
#define	ESCAPE_SETLAYER			248		// Start/End a layer
#define	ESCAPE_SETBOOKMARK		250		// set bookmark on current drawing operation
#define ESCAPE_SETBOOKMARKW		243		// Same as SETBOOKMARK with Unicode support
#define	ESCAPE_SETHYPERLINK		252		// set hyperlink on current drawing operation

// the following can be returned from the event handling function
#define DOCUMENTEVENT_SUCCESS     1
#define DOCUMENTEVENT_UNSUPPORTED 0
#define DOCUMENTEVENT_FAILURE     -1

// options for SetFileNameOptions
#define NoPrompt			0x00000001	// do not prompt for file name
#define UseFileName			0x00000002	// use file name set by SetDefaultFileName else use document name
#define Concatenate			0x00000004	// concatenate files, do not override
#define DisableCompression	0x00000008	// disable page content compression
#define EmbedFonts			0x00000010	// embed fonts used in the input document
#define BroadcastMessages	0x00000020	// broadcast PDF events
#define PrintWatermark		0x00000040	// add watermark to each page
#define MultilingualSupport	0x00000080	// activate multi-lingual support
#define EncryptDocument		0x00000100	// encrypt resulting document with a 40 bits key
#define FullEmbed			0x00000200  // embed full font
#define UseTcpIpServer		0x00000400	// send to a tcp/ip server
#define SendByEmail			0x00000800	// send by email
#define LinearizeForWeb		0x00008000	// web optimisation (Linearization)
#define PostProcessing		0x00010000	// post process file using specified application
#define JPegLevelLow		0x00020000	// Low JPeg compression
#define JPegLevelMedium		0x00040000	// Medium JPeg compression
#define JPegLevelHigh		0x00060000	// High JPeg compression

#define QualityLevelLow		0x00020000	// Low quality compression: equivalent to deprecated JPegLevelLow
#define QualityLevelMedium	0x00040000	// Medium quality compression: equivalent to deprecated JPegLevelMedium
#define QualityLevelHigh	0x00060000	// High quality compression: equivalent to deprecated JPegLevelHigh

#define Colors2GrayScale	0x00080000	// convert colors to gray scale
#define ConvertHyperlinks	0x00100000	// automatic hyperlink conversion
#define EmbedStandardFonts	0x00200000	// embed standard fonts such as Arial, Times, ...
#define EmbedLicensedFonts	0x00400000	// embed fonts requiring a license
#define Color256Compression	0x00800000	// activate 256 color compression
#define Jpeg2000Compression 0x01000000	// Use JPEG2000 compression 
#define SendToCreator		0x02000000	// page by page option
#define HTMLExport			0x04000000	// export in html format
#define RTFExport			0x08000000	// export in rtf format
#define JPEGExport			0x10000000	// export in jpeg format
#define CCITTCompression	0x20000000	// activate CCITT compression
#define EncryptDocument128	0x40000000	// encrypt resulting document by 128 bits enc
#define AutoCompression		0x80000000	// choose best algo for image compression
#define EncryptDocument256	0x40000100	// encrypt resulting document by 256 bits enc

// option values for ImageOptions
#define IO_NODUPLICATES		0x00000001	// remove duplicate images
#define IO_DOWNSAMPLE		0x00000002	// downsample high res images
#define IO_CONVERTTOCMYK	0x00000004	// convert colors to CMYK
#define IO_OUTPUTPDFA		0x00000008	// Output PDF/A file (old Acrobat 7 format)
#define IO_XMPMETADATA		0x00000010	// Output XMP metadata
#define IO_OUTPUTPDFA8		0x00000020	// Output PDF/A file (Acrobat 8 and newer format) 
#define IO_NOPRECOMPRESSED	0x00000040	// Disable direct PNG/JPEG output
#define IO_OUTPUTPDFX1		0x00000080	// Output PDF/X1 structures
#define IO_OUTPUTPDFX3		0x00000100	// Output PDF/X3 structures
#define IO_COMPRESSJBIG2	0x00000200	// Compression Black and White images using JBIG2
#define IO_DISABLEEPS		0x40000000	// do not process EPS blocks
#define IO_SIMPOSTSCRIPT	0x80000000	// alternative to SimPostscript


/********** Printer Initialization and Activation **********/

// init PDF driver
HANDLE WINAPI PDFDriverInit( LPCSTR szPrinter );

// init HTML driver
HANDLE WINAPI HTMLDriverInit( LPCSTR szPrinter );

// init RTF driver
HANDLE WINAPI RTFDriverInit( LPCSTR szPrinter );

// init any driver
HANDLE WINAPI DriverInit( LPCSTR szPrinter );

// init EMF driver
HANDLE WINAPI EMFDriverInit( LPCSTR szPrinter );

// end  driver
void WINAPI DriverEnd( HANDLE hPrinter );

// set default printer
long WINAPI CDISetDefaultPrinter( HANDLE hPrinter );
// set default printer: same function renamed for compatibility
// long WINAPI SetDefaultPrinter( HANDLE hPrinter );

// retore default printer
long WINAPI RestoreDefaultPrinter( HANDLE hPrinter );

// set the permanent license key for the product
BOOL WINAPI SetLicenseKeyA(LPCSTR szCompany, LPCSTR szLicKey);
BOOL WINAPI SetLicenseKeyW(LPCWSTR szCompany, LPCWSTR szLicKey);

// Developer version: enable printer before every print job
long WINAPI EnablePrinter(HANDLE hPrinter, LPCSTR szCompany, LPCSTR szCode);

// provide DOCX XML settings file name
long WINAPI SetDocxSettings( HANDLE hIntf, LPCSTR settingsFile );

// get/set printer attributes
long WINAPI SetPrinterAttributes( HANDLE hPrinter, DWORD dwAttributes );
DWORD WINAPI GetPrinterAttributes( HANDLE hPrinter );

// save/load configuration data
long WINAPI SaveCurrentConfig(HANDLE hIntf, LPCTSTR lpConfName, LPCTSTR lpConfDesc);
long WINAPI LoadSavedConfig(HANDLE hIntf, LPCTSTR lpConfName);

long WINAPI GetVersionInformation(HANDLE hIntf, long *CDIntfMajor, long *CDIntfMinor, long *PrinterDriverMajor, long *PrinterDriverMinor);

// offset from beginning of Devmode to the application's private area
long WINAPI GetPrivateAreaOffset();

//	supported languages
#define SPL_DEFAULT					0L		// Default
#define SPL_ENGLISH					1L		// English
#define SPL_FRENCH					2L		// French
#define SPL_GERMAN					3L		// German
#define SPL_ITALIAN					4L		// Italian
#define SPL_SPANISH					5L		// Spanish

// get/set language for user interface
long WINAPI GetPrinterLanguage(HANDLE hPrinter);
void WINAPI SetPrinterLanguage(HANDLE hPrinter, long nNewValue);

/********** Printer Configuration **********/
int WINAPI SetDefaultDirectory( HANDLE hPrinter, LPCSTR szDir );
int WINAPI SetDefaultDirectoryW( HANDLE hPrinter, LPCWSTR szDir );
int WINAPI SetDefaultFileName( HANDLE hPrinter, LPCSTR szFile );
int WINAPI SetDefaultFileNameW( HANDLE hPrinter, LPCWSTR szFile );
int WINAPI SetFileNameOptions( HANDLE hPrinter, int nOptions );

// image options
long WINAPI GetImageOptions(HANDLE hIntf);
void WINAPI SetImageOptions(HANDLE hIntf, long nNewValue);
long WINAPI GetInlineImageMaxSize(HANDLE hIntf);
void WINAPI SetInlineImageMaxSize(HANDLE hIntf, long nNewValue);
long WINAPI GetStringMaxSize(HANDLE hIntf);
void WINAPI SetStringMaxSize(HANDLE hIntf, long nNewValue);

BOOL WINAPI GetSimPostscript(HANDLE hIntf);
void WINAPI SetSimPostscript(HANDLE hIntf, BOOL fNewValue);

long WINAPI GetEncryption(HANDLE hIntf);
void WINAPI SetEncryption(HANDLE hIntf, long nNewValue);

// Various document attributes
int WINAPI SetTitle		( HANDLE hIntf, LPCSTR szValue );
int WINAPI SetTitleW	( HANDLE hIntf, LPCWSTR szValue );
int WINAPI SetAuthor	( HANDLE hIntf, LPCSTR szValue );
int WINAPI SetAuthorW	( HANDLE hIntf, LPCWSTR szValue );
int WINAPI SetCreator	( HANDLE hIntf, LPCSTR szValue );
int WINAPI SetCreatorW	( HANDLE hIntf, LPCWSTR szValue );
int WINAPI SetSubject	( HANDLE hIntf, LPCSTR szValue );
int WINAPI SetSubjectW	( HANDLE hIntf, LPCWSTR szValue );
int WINAPI SetKeywords	( HANDLE hIntf, LPCSTR szValue );
int WINAPI SetKeywordsW ( HANDLE hIntf, LPCWSTR szValue );

// get/set various printer options
long WINAPI GetPaperSize( HANDLE hPrinter );
long WINAPI SetPaperSize( HANDLE hPrinter, long nPaperSize );
long WINAPI GetPaperWidth( HANDLE hPrinter );
long WINAPI SetPaperWidth( HANDLE hPrinter, long nPaperWidth );
long WINAPI GetPaperLength( HANDLE hPrinter );
long WINAPI SetPaperLength( HANDLE hPrinter, long nPaperHeight );
long WINAPI GetOrientation( HANDLE hPrinter );
long WINAPI SetOrientation( HANDLE hPrinter, long nOrientation );
long WINAPI GetResolution( HANDLE hPrinter );
long WINAPI SetResolution( HANDLE hPrinter, long nResolution );
long WINAPI GetJPEGCompression( HANDLE hPrinter );
long WINAPI SetJPEGCompression( HANDLE hPrinter, BOOL bCompression );

long WINAPI GetJPegLevel( HANDLE hPrinter );
long WINAPI SetJPegLevel( HANDLE hPrinter, long nLevel );

// Replacement functions for deprecated GetJPegLevel/SetJPegLevel
long WINAPI GetQualityLevel( HANDLE hPrinter );
long WINAPI SetQualityLevel( HANDLE hPrinter, long nLevel );

BOOL WINAPI GetColor256Compression( HANDLE hPrinter );
long WINAPI SetColor256Compression( HANDLE hPrinter, BOOL bCompression );
BOOL WINAPI GetJPeg2000Compression( HANDLE hPrinter );
long WINAPI SetJPeg2000Compression( HANDLE hPrinter, BOOL bCompression );

long WINAPI GetFontEmbedding( HANDLE hPrinter );
long WINAPI SetFontEmbedding( HANDLE hPrinter, long bEmbedding );
long WINAPI GetHorizontalMargin( HANDLE hPrinter );
long WINAPI SetHorizontalMargin( HANDLE hPrinter, long nMargin );
long WINAPI GetVerticalMargin( HANDLE hPrinter );
long WINAPI SetVerticalMargin( HANDLE hPrinter, long nMargin );

int WINAPI SetPrinterParamStr( HANDLE hPrinter, LPCSTR szParam, LPCSTR szValue );
int WINAPI GetPrinterParamStr( HANDLE hPrinter, LPCSTR szParam, LPSTR szValue, int nLen );
int WINAPI SetPrinterParamStrW( HANDLE hPrinter, LPCSTR szParam, LPCWSTR szValue );
int WINAPI GetPrinterParamStrW( HANDLE hPrinter, LPCSTR szParam, LPWSTR szValue, int nLen );
int WINAPI SetPrinterParamInt( HANDLE hPrinter, LPCSTR szParam, long nValue );
long WINAPI GetPrinterParamInt( HANDLE hPrinter, LPCSTR szParam );

// set scaling options
long WINAPI GetScalingOption(HANDLE hIntf);
long WINAPI SetScalingOption(HANDLE hIntf, long nNewValue);
long WINAPI GetScalingPercent(HANDLE hIntf);
long WINAPI SetScalingPercent(HANDLE hIntf, long nNewValue);
short WINAPI GetScalingRows(HANDLE hIntf);
short WINAPI SetScalingRows(HANDLE hIntf, short nNewValue);
short WINAPI GetScalingColumns(HANDLE hIntf);
short WINAPI SetScalingColumns(HANDLE hIntf, short nNewValue);
short WINAPI GetScalingPaperSize(HANDLE hIntf);
short WINAPI SetScalingPaperSize(HANDLE hIntf, short nNewValue);
long WINAPI GetScalingWidth(HANDLE hIntf);
long WINAPI SetScalingWidth(HANDLE hIntf, long nNewValue);
long WINAPI GetScalingHeight(HANDLE hIntf);
long WINAPI SetScalingHeight(HANDLE hIntf, long nNewValue);
// Values for scaling info options
#define SIO_NONE					0
#define SIO_FITTOPAPERSIZE			1
#define SIO_SCALE					2
#define SIO_FIT						3

// set default configuration for all applications
long WINAPI SetDefaultConfig( HANDLE hPrinter );
// This version does not broadcast messages
long WINAPI SetDefaultConfigEx( HANDLE hPrinter );
// This version allows more flexibility
#define PRINTERCONFIG_GLOBALSETTINGS	1	// apply configuration to all users
#define PRINTERCONFIG_NOBROADCAST		2	// broadcast system messages about configuration change
long WINAPI SetPrinterConfig( HANDLE hPrinter, long Options );

// set watermark parameters
long WINAPI SetWatermark( HANDLE hPrinter, LPCSTR szWatermark, LPCSTR szFont, short fontSize,
						  short Orientation, COLORREF color, 
						  LONG xPos, LONG yPos, BOOL bForeground
						  );
long WINAPI SetWatermarkW( HANDLE hPrinter, LPCWSTR szWatermark, LPCWSTR szFont, short fontSize,
						  short Orientation, COLORREF color, 
						  LONG xPos, LONG yPos, BOOL bForeground
						  );
// Options values for the Watermarks Ex versions
#define WATERMARK_OPTION_FOREGROUND		1	// Watermark is on top of the document
#define WATERMARK_OPTION_RESERVED		2	// Always set to 0
#define WATERMARK_OPTION_FILE			4	// The watermark is in the file pointed to by szFileName
#define WATERMARK_OPTION_FIRSTPAGEONLY	8	// Place watermark on first page only
#define WATERMARK_OPTION_OUTLINE		16	// Outline text
#define WATERMARK_OPTION_ITALIC			32	// Italic text
#define WATERMARK_OPTION_UNDERLINE		64	// Underlined text
long WINAPI SetWatermarkEx( HANDLE hPrinter, LPCSTR szWatermark, LPCSTR szFont, short fontSize,
						  short Orientation, COLORREF color, 
						  LONG xPos, LONG yPos, LONG Options, LPCSTR szFileName
						  );
long WINAPI SetWatermarkExW( HANDLE hPrinter, LPCWSTR szWatermark, LPCWSTR szFont, short fontSize,
						  short Orientation, COLORREF color, 
						  LONG xPos, LONG yPos, LONG Options, LPCWSTR szFileName
						  );

// create a device context for this printer
HDC WINAPI CDICreateDC( HANDLE hPrinter );

/********** Encryption functions **********/
LPSTR WINAPI GetOwnerPassword(HANDLE hIntf, LPSTR szBuff, int iLen);
void WINAPI SetOwnerPassword(HANDLE hIntf, LPCSTR lpszNewValue);
LPSTR WINAPI GetUserPassword(HANDLE hIntf, LPSTR szBuff, int iLen);
void WINAPI SetUserPassword(HANDLE hIntf, LPCSTR lpszNewValue);
long WINAPI GetPermissions(HANDLE hIntf);
void WINAPI SetPermissions(HANDLE hIntf, long nNewValue);

/********** Email functions **********/
// MAPI email parameters
int WINAPI SetEmailFieldFrom(HANDLE hPrinter, LPCSTR szEmailFieldFrom);
int WINAPI SetEmailFieldTo( HANDLE hPrinter, LPCSTR szEmailFieldTo);
int WINAPI SetEmailFieldCC( HANDLE hPrinter, LPCSTR szEmailFieldCC);
int WINAPI SetEmailFieldBCC( HANDLE hPrinter, LPCSTR szEmailFieldBCC);
int WINAPI SetEmailSubject( HANDLE hPrinter, LPCSTR szEmailSubject);
int WINAPI SetEmailMessage( HANDLE hPrinter, LPCSTR szEmailMessage);
int WINAPI SetEmailPrompt( HANDLE hPrinter, BOOL bEmailPrompt);

//	EMail Options
#define SMO_PROMPT_PROFILE			1L		// not used anymore
#define SMO_PROMPT_RECIPIENT		2L		// prompt before sending MAPI emails
#define SMO_SMTP_MAIL				4L		// send by SMTP and not MAPI
long WINAPI GetEmailOptions(HANDLE hPrinter);
long WINAPI SetEmailOptions(HANDLE hPrinter, long nEmailOptions);

// SMTP email parameters
int WINAPI SetSmtpServer(HANDLE hPrinter, LPCSTR szSmtpServer);
int WINAPI SetSmtpPort(HANDLE hPrinter, long lSmtpPort);
int WINAPI SetSmtpUsername(HANDLE hIntf, LPCSTR szSmtpUsername);
int WINAPI SetSmtpPassword(HANDLE hIntf, LPCSTR szSmtpPassword);

//	Send an email with file attachments using MAPI
long WINAPI SendMail(LPCSTR szTo, LPCSTR szCC, LPCSTR szBCC, LPCSTR szSubject, LPCSTR szMessage, LPCSTR szFilenames, long lOptions);
//	Send an email with file attachments using MAPI (unicode)
long WINAPI SendMailW(LPCWSTR szTo, LPCWSTR szCC, LPCWSTR szBCC, LPCWSTR szSubject, LPCWSTR szMessage, LPCWSTR szFilenames, long lOptions);

//	Send an email with file attachments using smtp
long WINAPI SendSmtpMail(LPCSTR szHostname, long lPort, LPCSTR szFrom, LPCSTR szTo, LPCSTR szCC, LPCSTR szBCC, LPCSTR szSubject, LPCSTR szMessage, LPCSTR szFilenames);
//	Send an email with file attachments using smtp (unicode)
long WINAPI SendSmtpMailW(LPCWSTR szHostname, long lPort, LPCWSTR szFrom, LPCWSTR szTo, LPCWSTR szCC, LPCWSTR szBCC, LPCWSTR szSubject, LPCWSTR szMessage, LPCWSTR szFilenames);

//	Send an email with file attachments using smtp with authentication
long WINAPI SendSmtpMailEx(LPCSTR szHostname, long lPort, LPCSTR szUsername, LPCSTR szPassword, LPCSTR szFrom, LPCSTR szTo, LPCSTR szCC, LPCSTR szBCC, LPCSTR szSubject, LPCSTR szMessage, LPCSTR szFilenames);
//	Send an email with file attachments using smtp with authentication (unicode)
long WINAPI SendSmtpMailExW(LPCWSTR szHostname, long lPort, LPCWSTR szUsername, LPCWSTR szPassword, LPCWSTR szFrom, LPCWSTR szTo, LPCWSTR szCC, LPCWSTR szBCC, LPCWSTR szSubject, LPCWSTR szMessage, LPCWSTR szFilenames);

// Roberto: May 2, 2011 Making the code more clear: unifying coding
long SendSmtpMailExInternal (LPCWSTR szHostname, long lPort, LPCWSTR szUsername, LPCWSTR szPassword, LPCWSTR szFrom, LPCWSTR szTo, LPCWSTR szCC, LPCWSTR szBCC, LPCWSTR szSubject, LPCWSTR szMessage, LPCWSTR szFilenames, LPCWSTR szFileTitles );

/********** Print Job Locking Functions **********/
int WINAPI Lock(HANDLE hPrinter, LPCSTR szDocTitle);
int WINAPI Unlock(HANDLE hPrinter, LPCSTR szDocTitle, long dwTimeout);
int WINAPI SetDocFileProps(HANDLE hPrinter, LPCSTR szDocTitle, long lOptions, LPCSTR szFileDir, LPCSTR szFileName);

int WINAPI LockW(HANDLE hPrinter, LPCWSTR szDocTitle);
int WINAPI UnlockW(HANDLE hPrinter, LPCWSTR szDocTitle, long dwTimeout);
int WINAPI SetDocFilePropsW(HANDLE hPrinter, LPCWSTR szDocTitle, long lOptions, LPCWSTR szFileDir, LPCWSTR szFileName);


/********** PDF File Processing **********/
BOOL WINAPI ConcatenateFiles( LPCSTR file1, LPCSTR file2, LPCSTR file3 );
BOOL WINAPI MergeFiles( LPCSTR file1, LPCSTR file2, LPCSTR file3, long Options );
BOOL WINAPI ConcatenateFilesW( LPCWSTR file1, LPCWSTR file2, LPCWSTR file3 );
BOOL WINAPI MergeFilesW( LPCWSTR file1, LPCWSTR file2, LPCWSTR file3, long Options );

// encrypt PDF document
BOOL WINAPI EncryptPDFDocument( LPCSTR FileName, LPCSTR Owner, LPCSTR User, 
							    DWORD Permissions );
BOOL WINAPI EncryptPDFDocument128( LPCSTR FileName, LPCSTR Owner, LPCSTR User, 
							    DWORD Permissions );
BOOL WINAPI EncryptPDFDocument256( LPCSTR FileName, LPCSTR Owner, LPCSTR User, 
							    DWORD Permissions );
BOOL WINAPI EncryptPDFDocumentW( LPCWSTR FileName, LPCSTR Owner, LPCSTR User, 
							    DWORD Permissions );
BOOL WINAPI EncryptPDFDocument128W( LPCWSTR FileName, LPCSTR Owner, LPCSTR User, 
							    DWORD Permissions );
BOOL WINAPI EncryptPDFDocument256W( LPCWSTR FileName, LPCSTR Owner, LPCSTR User, 
							    DWORD Permissions );

// linearize PDF document
BOOL WINAPI LinearizePDFDocument( LPCSTR FileName );
BOOL WINAPI LinearizePDFDocumentW( LPCWSTR FileName );

// print a PDF document
BOOL WINAPI PrintPDFDocument( LPCSTR FileName, LPCSTR PrinterName, long StartPage, long EndPage, long Copies );
BOOL WINAPI PrintPDFDocumentW( LPCWSTR FileName, LPCWSTR PrinterName, long StartPage, long EndPage, long Copies );
// print a password protected PDF document
BOOL WINAPI PrintPDFDocumentEx( LPCSTR FileName, LPCSTR Password, LPCSTR PrinterName, long StartPage, long EndPage, long Copies );
BOOL WINAPI PrintPDFDocumentExW( LPCWSTR FileName, LPCSTR Password, LPCWSTR PrinterName, long StartPage, long EndPage, long Copies );

// convert a PDF file to an RTF file
#define RTFOPTION_ADVANCED	0			// use frames to position objects
#define RTFOPTION_FULL		1			// Text, Graphics and images with no frames
#define RTFOPTION_RTFTEXT	2			// Formatted Text only
#define RTFOPTION_TEXT		3			// Simple text, non-formatted
#define RTFOPTION_NOTABS	0x10000		// replace tabs with spaces
long WINAPI PDF2RTF( LPCSTR InputFile, LPCSTR  Password, LPCSTR OutputFile, long Options, long OptimizeLevel );
long WINAPI PDF2RTFW( LPCWSTR InputFile, LPCSTR  Password, LPCWSTR OutputFile, long Options, long OptimizeLevel );

// convert a PDF file to an HTML file
#define HTMLOPTION_LAYERS			1			// single HTML using layers
#define HTMLOPTION_SINGLE_PAGE		2			// single HTML not using layers
#define HTMLOPTION_MULTIPLE_PAGES	3			// multiple HTML documents
long WINAPI PDF2HTML( LPCSTR InputFile, LPCSTR  Password, LPCSTR OutputFile, long Options, long OptimizeLevel );
long WINAPI PDF2HTMLW( LPCWSTR InputFile, LPCSTR  Password, LPCWSTR OutputFile, long Options, long OptimizeLevel );

// convert a PDF file to an HTML5 file
#define HTML5OPTION_INCLUDEHEADER 1
#define HTML5OPTION_EMBEDIMAGES   2
#define HTML5OPTION_UTF8ENCODING  4
#define HTML5OPTION_UTF16ENCODING 8
#define HTML5OPTION_DEFAULT		  7 //( HTML5OPTION_INCLUDEHEADER | HTML5OPTION_EMBEDIMAGES | HTML5OPTION_UTF8ENCODING )
long WINAPI PDF2HTML5( LPCSTR InputFile, LPCSTR  Password, LPCSTR OutputFile, long Options, long OptimizeLevel );
long WINAPI PDF2HTML5W( LPCWSTR InputFile, LPCSTR  Password, LPCWSTR OutputFile, long Options, long OptimizeLevel );

// convert a PDF file to an EXCEL file
#define EXCELOPTION_SINGLE_SHEET	0
#define EXCELOPTION_MULTIPLE_SHEETS	1
long WINAPI PDF2EXCEL( LPCSTR InputFile, LPCSTR Password, LPCSTR OutputFile, long Options, long OptimizeLevel );
long WINAPI PDF2EXCELW( LPCWSTR InputFile, LPCSTR Password, LPCWSTR OutputFile, long Options, long OptimizeLevel );

// convert a PDF file to a JPEG file
// the options parameter is a combination of two 16 bits values
// the low 16 bits contain the JPeg compression level
// the high 16 bits contain the resolution
#define JPEGOPTION_DEFAULT	0x012C0007	// same as JPEGOPTION_MEDIUM
#define JPEGOPTION_LOW		0x00960003	// low resolution 150 DPI, JPeg level 3
#define JPEGOPTION_MEDIUM	0x012C0007	// default to 300 DPI, JPeg level 7
#define JPEGOPTION_HIGH		0x02580009	// high resolution 600 DPI, JPeg level 9 (could be very slow)
long WINAPI PDF2JPEG( LPCSTR InputFile, LPCSTR Password, LPCSTR OutputFile, long Options, long OptimizeLevel );
long WINAPI PDF2JPEGW( LPCWSTR InputFile, LPCSTR Password, LPCWSTR OutputFile, long Options, long OptimizeLevel );

// convert a PDF file to a TIFF file
// the options parameter is a combination of two 16 bits values
// the low 16 bits contain the Tiff compression level
// the high 16 bits contain the resolution
#define TIFFOPTION_DEFAULT	0x012C0000	// 300 DPI, no compression
#define TIFFOPTION_LOW		0x0096000A	// low resolution 150 DPI, CCITT compression
#define TIFFOPTION_MEDIUM	0x012C000A	// default to 300 DPI, CCITT compression
#define TIFFOPTION_HIGH		0x0258000A	// high resolution 600 DPI, CCITT compression (could be very slow)
long WINAPI PDF2TIFF( LPCSTR InputFile, LPCSTR Password, LPCSTR OutputFile, long Options, long OptimizeLevel );
long WINAPI PDF2TIFFW( LPCWSTR InputFile, LPCSTR Password, LPCWSTR OutputFile, long Options, long OptimizeLevel );

// convert a PDF file to an XPS file
long WINAPI PDF2XPS( LPCSTR InputFile, LPCSTR Password, LPCSTR OutputFile, long Options, long OptimizeLevel );

// attach a color profile to the printer
int WINAPI SetColorProfile(HANDLE hPrinter, LPCSTR szColorProfile);

/********** General Functions **********/
long WINAPI SetBookmark( HANDLE hDC, long lParent, LPCSTR szTitle );
long WINAPI SetBookmarkW( HANDLE hDC, long lParent, LPCWSTR szTitle );
long WINAPI SetHyperLink( HANDLE hDC, LPCSTR szURL );
long WINAPI CaptureEvents( HANDLE hPrinter, BOOL bCapture );

// error message associated with error code
void WINAPI GetLastErrorMsg( LPSTR Msg, long MaxMsg );
void WINAPI GetDocumentTitle( HANDLE hPrinter, long JobID, LPSTR buf, long MaxBuf );
void WINAPI GetGeneratedFilename(HANDLE hPrinter, LPSTR Buf, int MaxBuf);
void WINAPI GetGeneratedFilenameW(HANDLE hPrinter, LPWSTR Buf, int MaxBuf);

// set the destination window for notification messages
long WINAPI SendMessagesTo( HANDLE hPrinter, LPCSTR szWndClass );

// convert several files in batch mode
long WINAPI BatchConvertEx( HANDLE hPrinter, LPSTR szFileName );

int WINAPI SetTargetPrinterName(HANDLE hPrinter, LPCSTR szTargetPrinterName);

int WINAPI SetPageProcessor(HANDLE hPrinter, LPCSTR szPageProcDll);

/********** TCP/IP functions **********/
int WINAPI SetServerAddress( HANDLE hPrinter, LPCSTR szServerAddress );
int WINAPI SetServerPort( HANDLE hPrinter, long lServerPort);
int WINAPI SetServerUsername( HANDLE hPrinter, LPCSTR szServerUsername);

/********** Reserved (Undocumented) **********/
long WINAPI GetCompression( HANDLE hPrinter );
long WINAPI SetCompression( HANDLE hPrinter, long bCompression );
BOOL WINAPI KeepPreProcessed(HANDLE hPrinter, BOOL fKeep);
long WINAPI GetDevmodeFlags( HANDLE hPrinter );
long WINAPI SetDevmodeFlags( HANDLE hPrinter, long dwFlags );
int WINAPI TestLock(HANDLE hPrinter, LPCSTR szLockName);
int WINAPI GLock(HANDLE hPrinter);
int WINAPI GUnlock(HANDLE hPrinter);

// advanced functions
typedef HANDLE EXTDOCHANDLE;
int WINAPI DocOpenA(EXTDOCHANDLE* pedhDocument, LPCSTR szFileName, LPBYTE szPassword);
int WINAPI DocOpenW(EXTDOCHANDLE* pedhDocument, LPCWSTR szFileName, LPBYTE szPassword);
int WINAPI DocClose(EXTDOCHANDLE edhDocument);
int WINAPI DocAppend(EXTDOCHANDLE edhDocument, EXTDOCHANDLE edhSource);
int WINAPI DocMerge(EXTDOCHANDLE edhDocument, EXTDOCHANDLE edhSource, BOOL fRepeat, BOOL fAbove);
int WINAPI DocAddWatermarkA(EXTDOCHANDLE edhDocument, EXTDOCHANDLE* pedhResultDoc, LPCSTR szWatermarkText,  LPCSTR font, short fontSize, short orientation, int color, int xpos, int ypos, short options);
int WINAPI DocAddWatermarkW(EXTDOCHANDLE edhDocument, EXTDOCHANDLE* pedhResultDoc, LPCWSTR szWatermarkText, LPCWSTR font, short fontSize, short orientation, int color, int xpos, int ypos, short options);
int WINAPI DocEncryptA(EXTDOCHANDLE edhDocument, LPCSTR szOwnerPassword, LPCSTR szUserPassword, DWORD dwPermissions);
int WINAPI DocEncryptW(EXTDOCHANDLE edhDocument, LPCWSTR szOwnerPassword, LPCWSTR szUserPassword, DWORD dwPermissions);
int WINAPI DocEncrypt128A(EXTDOCHANDLE edhDocument, LPCSTR szOwnerPassword, LPCSTR szUserPassword, DWORD dwPermissions);
int WINAPI DocEncrypt128W(EXTDOCHANDLE edhDocument, LPCWSTR szOwnerPassword, LPCWSTR szUserPassword, DWORD dwPermissions);
int WINAPI DocEncrypt256A(EXTDOCHANDLE edhDocument, LPCSTR szOwnerPassword, LPCSTR szUserPassword, DWORD dwPermissions);
int WINAPI DocEncrypt256W(EXTDOCHANDLE edhDocument, LPCWSTR szOwnerPassword, LPCWSTR szUserPassword, DWORD dwPermissions);
int WINAPI DocLinearize(EXTDOCHANDLE edhDocument);
int WINAPI DocSaveA(EXTDOCHANDLE edhDocument, LPCSTR szFileName);
int WINAPI DocSaveW(EXTDOCHANDLE edhDocument, LPCWSTR szFileName);
int WINAPI DocSaveExA(EXTDOCHANDLE edhDocument, LPCSTR szFileName, int Options);
int WINAPI DocSaveExW(EXTDOCHANDLE edhDocument, LPCWSTR szFileName, int Options);
int WINAPI DocEmailMapiA(LPCSTR szTo, LPCSTR szCC, LPCSTR szBCC, LPCSTR szSubject, LPCSTR szMessage, LPCSTR szFileName, LPCSTR szFileTitle, long lOptions);
int WINAPI DocEmailMapiW(LPCWSTR szTo, LPCWSTR szCC, LPCWSTR szBCC, LPCWSTR szSubject, LPCWSTR szMessage, LPCWSTR szFileName, LPCWSTR szFileTitle, long lOptions);
int WINAPI DocEmailSmtpA(LPCSTR szHostname, long lPort, LPCSTR szFrom, LPCSTR szTo, LPCSTR szCC, LPCSTR szBCC, LPCSTR szSubject, LPCSTR szMessage, LPCSTR szFileName, LPCSTR szFileTitle);
int WINAPI DocEmailSmtpW(LPCWSTR szHostname, long lPort, LPCWSTR szFrom, LPCWSTR szTo, LPCWSTR szCC, LPCWSTR szBCC, LPCWSTR szSubject, LPCWSTR szMessage, LPCWSTR szFileName, LPCWSTR szFileTitle);
int WINAPI DocEmailSmtpExA(LPCSTR szHostname, long lPort, LPCSTR szUsername, LPCSTR szPassword, LPCSTR szFrom, LPCSTR szTo, LPCSTR szCC, LPCSTR szBCC, LPCSTR szSubject, LPCSTR szMessage, LPCSTR szFileName, LPCSTR szFileTitle);
int WINAPI DocEmailSmtpExW(LPCWSTR szHostname, long lPort, LPCWSTR szUsername, LPCWSTR szPassword, LPCWSTR szFrom, LPCWSTR szTo, LPCWSTR szCC, LPCWSTR szBCC, LPCWSTR szSubject, LPCWSTR szMessage, LPCWSTR szFileName, LPCWSTR szFileTitle);
int WINAPI DocOptimize(EXTDOCHANDLE edhDocument, int iLevel);
int WINAPI DocConvertToHTMLA(EXTDOCHANDLE edhDocument, LPCSTR FileName, DWORD MultipageOptions);
int WINAPI DocConvertToHTMLW(EXTDOCHANDLE edhDocument, LPCWSTR FileName, DWORD MultipageOptions);
int WINAPI DocConvertToRTFA(EXTDOCHANDLE edhDocument, LPCSTR FileName, DWORD OutputOptions, BOOL useTab);
int WINAPI DocConvertToRTFW(EXTDOCHANDLE edhDocument, LPCWSTR FileName, DWORD OutputOptions, BOOL useTab);
int WINAPI DocConvertToJPEGA(EXTDOCHANDLE edhDocument, LPCSTR FileName, DWORD Resolution, DWORD JpegLevel);
int WINAPI DocConvertToJPEGW(EXTDOCHANDLE edhDocument, LPCWSTR FileName, DWORD Resolution, DWORD JpegLevel);
int WINAPI DocConvertToEXCELA(EXTDOCHANDLE edhDocument, LPCSTR FileName, DWORD OutputOptions);
int WINAPI DocConvertToEXCELW(EXTDOCHANDLE edhDocument, LPCWSTR FileName, DWORD OutputOptions);
int WINAPI DocConvertToTIFFA(EXTDOCHANDLE edhDocument, LPCSTR FileName, DWORD Resolution, DWORD OutputOptions);
int WINAPI DocConvertToTIFFW(EXTDOCHANDLE edhDocument, LPCWSTR FileName, DWORD Resolution, DWORD OutputOptions);
int WINAPI DocConvertToXPSA(EXTDOCHANDLE edhDocument, LPCSTR FileName, DWORD OutputOptions);
int WINAPI DocConvertToXPSW(EXTDOCHANDLE edhDocument, LPCWSTR FileName, DWORD OutputOptions);
int WINAPI DocConvertToDOCXA(EXTDOCHANDLE edhDocument, LPCSTR FileName, LPBYTE docxSettingsXMLData, DWORD count);
int WINAPI DocConvertToDOCXW(EXTDOCHANDLE edhDocument, LPCWSTR FileName, LPBYTE docxSettingsXMLData, DWORD count);
int WINAPI DocPrintA(EXTDOCHANDLE edhDocument, LPCSTR szPrinterName, long lStartPage, long lEndPage, long lCopies);
int WINAPI DocPrintW(EXTDOCHANDLE edhDocument, LPCWSTR szPrinterName, long lStartPage, long lEndPage, long lCopies);
int WINAPI DocAutoHyperLinksA(EXTDOCHANDLE edhDocument, LPCSTR Prefix);
int WINAPI DocAutoHyperLinksW(EXTDOCHANDLE edhDocument, LPCWSTR Prefix);
int WINAPI DocAutoBookmarksA(EXTDOCHANDLE edhDocument, long Levels, LPCSTR FontSet, long StartPage);
int WINAPI DocAutoBookmarksW(EXTDOCHANDLE edhDocument, long Levels, LPCWSTR FontSet, long StartPage);
int WINAPI DocSetHyperLinkInternal(EXTDOCHANDLE edhDocument, long PageNumber, long xStart, long yStart, long xEnd, long yEnd, long DestPageNumber, long DestX, long DestY);
int WINAPI DocSetHyperLinkURLA(EXTDOCHANDLE edhDocument, long PageNumber, long xStart, long yStart, long xEnd, long yEnd, LPCSTR URL);
int WINAPI DocSetHyperLinkURLW(EXTDOCHANDLE edhDocument, long PageNumber, long xStart, long yStart, long xEnd, long yEnd, LPCWSTR URL);
int WINAPI DocSetBookmarkXYA(EXTDOCHANDLE edhDocument, long Page, long xPos, long yPos, LPCSTR Text, long Level);
int WINAPI DocSetBookmarkXYW(EXTDOCHANDLE edhDocument, long Page, long xPos, long yPos, LPCWSTR Text, long Level);
int WINAPI DocSplitA(EXTDOCHANDLE edhDocument, LPCSTR prefix);
int WINAPI DocSplitW(EXTDOCHANDLE edhDocument, LPCWSTR prefix);
int WINAPI DocSplitXYA(EXTDOCHANDLE edhDocument, LPCSTR prefix, long X, long Y);
int WINAPI DocSplitXYW(EXTDOCHANDLE edhDocument, LPCWSTR prefix, long X, long Y);

// options for the Flags parameter of DocDigitalSignature
#define	SIGNATURE_DISPLAY_SIGNER 1
#define	SIGNATURE_DISPLAY_REASON 2
#define	SIGNATURE_DISPLAY_LOCATION 4
#define	SIGNATURE_DISPLAY_IMAGE 8
#define	SIGNATURE_DISPLAY_CERTIFICATE 16
#define	SIGNATURE_DISPLAY_DATE 32
#define	SIGNATURE_DISPLAY_TYPE 64
int WINAPI DocDigitalSignatureA(EXTDOCHANDLE edhDocument, LPCSTR SignedBy, LPCSTR Reason, LPCSTR ImageFile, LPCSTR Location, long PageNumber, long HorzPos, long VertPos, long Width, long Height, long Flags);
int WINAPI DocDigitalSignatureW(EXTDOCHANDLE edhDocument, LPCWSTR SignedBy, LPCWSTR Reason, LPCWSTR ImageFile, LPCWSTR Location, long PageNumber, long HorzPos, long VertPos, long Width, long Height, long Flags);
int WINAPI DocDigitalSignatureExA(EXTDOCHANDLE edhDocument, LPCSTR SignedBy, LPCSTR Reason, LPCSTR ImageFile, LPCSTR Location, long PageNumber, long HorzPos, long VertPos, long Width, long Height, long Flags, LPCSTR Store, LPCSTR DateFormat);
int WINAPI DocDigitalSignatureExW(EXTDOCHANDLE edhDocument, LPCWSTR SignedBy, LPCWSTR Reason, LPCWSTR ImageFile, LPCWSTR Location, long PageNumber, long HorzPos, long VertPos, long Width, long Height, long Flags, LPCWSTR Store, LPCWSTR DateFormat);

// title, subject, creator, author and keywords 
int WINAPI DocSetTitleA(EXTDOCHANDLE edhDocument, LPCSTR szValue);
int WINAPI DocSetSubjectA(EXTDOCHANDLE edhDocument, LPCSTR szValue);
int WINAPI DocSetCreatorA(EXTDOCHANDLE edhDocument, LPCSTR szValue);
int WINAPI DocSetAuthorA(EXTDOCHANDLE edhDocument, LPCSTR szValue);
int WINAPI DocSetKeywordsA(EXTDOCHANDLE edhDocument, LPCSTR szValue);

int WINAPI DocSetTitleW(EXTDOCHANDLE edhDocument, LPCWSTR szValue);
int WINAPI DocSetSubjectW(EXTDOCHANDLE edhDocument, LPCWSTR szValue);
int WINAPI DocSetCreatorW(EXTDOCHANDLE edhDocument, LPCWSTR szValue);
int WINAPI DocSetAuthorW(EXTDOCHANDLE edhDocument, LPCWSTR szValue);
int WINAPI DocSetKeywordsW(EXTDOCHANDLE edhDocument, LPCWSTR szValue);

int WINAPI DocGetTitleW(EXTDOCHANDLE edhDocument, LPCWSTR szValue, int len);
int WINAPI DocGetSubjectW(EXTDOCHANDLE edhDocument, LPCWSTR szValue, int len);
int WINAPI DocGetCreatorW(EXTDOCHANDLE edhDocument, LPCWSTR szValue, int len);
int WINAPI DocGetAuthorW(EXTDOCHANDLE edhDocument, LPCWSTR szValue, int len);
int WINAPI DocGetKeywordsW(EXTDOCHANDLE edhDocument, LPCWSTR szValue, int len);

int WINAPI DocAddFileAttachmentA(EXTDOCHANDLE edhDocument, LPCSTR Name, LPCSTR Filename, LPCSTR Description, LPCSTR ContentType);
int WINAPI DocAddFileAttachmentW(EXTDOCHANDLE edhDocument, LPCWSTR Name, LPCWSTR Filename, LPCWSTR Description, LPCWSTR ContentType);
int WINAPI DocAddFileAttachmentExA(EXTDOCHANDLE edhDocument, LPCSTR Name, LPCSTR Filename, LPCSTR Description, LPCSTR ContentType, LPCSTR Relationship);
int WINAPI DocAddFileAttachmentExW(EXTDOCHANDLE edhDocument, LPCWSTR Name, LPCWSTR Filename, LPCWSTR Description, LPCWSTR ContentType, LPCWSTR Relationship);
int WINAPI DocDeleteFileAttachmentA(EXTDOCHANDLE edhDocument, LPCSTR Name);
int WINAPI DocDeleteFileAttachmentW(EXTDOCHANDLE edhDocument, LPCWSTR Name);
int WINAPI DocExtractFileAttachmentA(EXTDOCHANDLE edhDocument, LPCSTR Name, LPCSTR Foldername);
int WINAPI DocExtractFileAttachmentW(EXTDOCHANDLE edhDocument, LPCWSTR Name, LPCWSTR Foldername);
int WINAPI DocSetMarkedContentA(EXTDOCHANDLE edhDocument, long PageNumber, long xStart, long yStart, long xEnd, long yEnd, LPCSTR Tag, LPCSTR Attributes);
int WINAPI DocSetMarkedContentW(EXTDOCHANDLE edhDocument, long PageNumber, long xStart, long yStart, long xEnd, long yEnd, LPCWSTR Tag, LPCWSTR Attributes);

int WINAPI PreviewPdfFileW(HWND hParent, LPCWSTR szPrinterName, LPCWSTR szFilename, LPBYTE szPassword, DWORD dwOptions);
int WINAPI PreviewPdfFileA(HWND hParent, LPCSTR szPrinterName,  LPCSTR szFilename,  LPBYTE szPassword, DWORD dwOptions);
long WINAPI SendThroughPDFCourierW(LPCWSTR szFrom, LPCWSTR szAccount, LPCWSTR szPassword, LPCWSTR szTo, LPCWSTR szCC, LPCWSTR szSubject, LPCWSTR szMessage, LPCWSTR szFilename, LPCWSTR szDisplayName, long lOptions);
long WINAPI SendThroughPDFCourierA(LPCSTR szFrom, LPCSTR szAccount, LPCSTR szPassword, LPCSTR szTo, LPCSTR szCC, LPCSTR szSubject, LPCSTR szMessage, LPCSTR szFilename, LPCSTR szDisplayName, long lOptions);

int WINAPI DocGetAutoPrint(EXTDOCHANDLE edhDocument, BOOL * value);
int WINAPI DocSetAutoPrint(EXTDOCHANDLE edhDocument, BOOL value);

#define PRINTOPTIONS_IMAGEGDIPLUS 1
#define PRINTOPTIONS_USEPDFFONTS  2
#define PRINTOPTIONS_USEGDI		  4
#define PRINTOPTIONS_USEDIRECTX	  8
int WINAPI DocOpenForPrintingA(EXTDOCHANDLE * edhDocument, LPCSTR szFileName, LPBYTE szPassword, long Options);
int WINAPI DocOpenForPrintingW(EXTDOCHANDLE * edhDocument, LPCWSTR szFileName, LPBYTE szPassword, long Options);
int WINAPI DocClearBookmarks(EXTDOCHANDLE edhDocument);
int WINAPI DocGetPageCount(EXTDOCHANDLE edhDocument, int * pageCount);
int WINAPI DocSearchTextA(EXTDOCHANDLE edhDocument, short Start, LPCSTR Text, long* Page, double* xPos, double* yPos);
int WINAPI DocSearchTextW(EXTDOCHANDLE edhDocument, short Start, LPCWSTR Text, long* Page, double* xPos, double* yPos);

// callbacks from the printer driver
typedef LPVOID DOCHANDLE;
typedef DOCHANDLE* LPDOCHANDLE;
int WINAPI PPInit();
int WINAPI PPStartDoc(LPDOCHANDLE phDoc, DWORD dwFlags);
int WINAPI PPEndDoc(DOCHANDLE hDoc);
int WINAPI PPStartPage(DOCHANDLE hDoc);
int WINAPI PPEndPage(DOCHANDLE hDoc);
int WINAPI PPStartObject(DOCHANDLE hDoc);
int WINAPI PPEndObject(DOCHANDLE hDoc);
int WINAPI PPWriteBuffer(DOCHANDLE hDoc, LPBYTE pData, DWORD dwSize);

// Get new or renew existing Amyuni Licensing System license ( license=computerID, code=ActivationCode )
int WINAPI GetALSLicenseKey( CHAR *szLicense, CHAR *szCode );
int WINAPI RenewALSLicenseKey( CHAR *szLicense, CHAR *szCode );
#ifdef __cplusplus
}
#endif
